/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;

class ControlPanel
extends JPanel {
    private JTextField tfLevel = new JTextField("5");
    private JTextField tfScore = new JTextField("0");
    private JButton btPlay = new JButton("Play");
    private JButton btPause = new JButton("Pause");
    private JButton btStop = new JButton("Stop");
    private JButton btTurnLevelUp = new JButton("Turn hard");
    private JButton btTurnLevelDown = new JButton("Turn easy");
    private JPanel plTip = new JPanel(new BorderLayout());
    private TipPanel plTipBlock = new TipPanel();
    private JPanel plInfo = new JPanel(new GridLayout(4, 1));
    private JPanel plButton = new JPanel(new GridLayout(5, 1));
    private Timer timer;
    private ErsBlocksGame game;
    private Border border = new EtchedBorder(0, Color.white, new Color(148, 145, 140));

    public ControlPanel(final ErsBlocksGame ersBlocksGame) {
        this.setLayout(new GridLayout(3, 1, 0, 4));
        this.game = ersBlocksGame;
        this.plTip.add((Component)new JLabel("Next block"), "North");
        this.plTip.add(this.plTipBlock);
        this.plTip.setBorder(this.border);
        this.plInfo.add(new JLabel("Level"));
        this.plInfo.add(this.tfLevel);
        this.plInfo.add(new JLabel("Score"));
        this.plInfo.add(this.tfScore);
        this.plInfo.setBorder(this.border);
        this.tfLevel.setEditable(false);
        this.tfScore.setEditable(false);
        this.plButton.add(this.btPlay);
        this.plButton.add(this.btPause);
        this.plButton.add(this.btStop);
        this.plButton.add(this.btTurnLevelUp);
        this.plButton.add(this.btTurnLevelDown);
        this.plButton.setBorder(this.border);
        this.add(this.plTip);
        this.add(this.plInfo);
        this.add(this.plButton);
        this.addKeyListener(new ControlKeyListener());
        this.btPlay.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ersBlocksGame.playGame();
            }
        });
        this.btPause.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (ControlPanel.this.btPause.getText().equals(new String("Pause"))) {
                    ersBlocksGame.pauseGame();
                } else {
                    ersBlocksGame.resumeGame();
                }
            }
        });
        this.btStop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ersBlocksGame.stopGame();
            }
        });
        this.btTurnLevelUp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = Integer.parseInt(ControlPanel.this.tfLevel.getText());
                    if (n < 10) {
                        ControlPanel.this.tfLevel.setText("" + (n + 1));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                ControlPanel.this.requestFocus();
            }
        });
        this.btTurnLevelDown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = Integer.parseInt(ControlPanel.this.tfLevel.getText());
                    if (n > 1) {
                        ControlPanel.this.tfLevel.setText("" + (n - 1));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                ControlPanel.this.requestFocus();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                ControlPanel.this.plTipBlock.fanning();
            }
        });
        this.timer = new Timer(500, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControlPanel.this.tfScore.setText("" + ersBlocksGame.getScore());
                int n = ersBlocksGame.getScoreForLevelUpdate();
                if (n >= 2000 && n > 0) {
                    ersBlocksGame.levelUpdate();
                }
            }
        });
        this.timer.start();
    }

    public void setTipStyle(int n) {
        this.plTipBlock.setStyle(n);
    }

    public int getLevel() {
        int n = 0;
        try {
            n = Integer.parseInt(this.tfLevel.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    public void setLevel(int n) {
        if (n > 0 && n < 11) {
            this.tfLevel.setText("" + n);
        }
    }

    public void setPlayButtonEnable(boolean bl) {
        this.btPlay.setEnabled(bl);
    }

    public void setPauseButtonLabel(boolean bl) {
        this.btPause.setText(bl ? "Pause" : "Continue");
    }

    public void reset() {
        this.tfScore.setText("0");
        this.plTipBlock.setStyle(0);
    }

    public void fanning() {
        this.plTipBlock.fanning();
    }

    private class ControlKeyListener
    extends KeyAdapter {
        private ControlKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (!ControlPanel.this.game.isPlaying()) {
                return;
            }
            ErsBlock ersBlock = ControlPanel.this.game.getCurBlock();
            switch (keyEvent.getKeyCode()) {
                case 40: {
                    ersBlock.moveDown();
                    break;
                }
                case 37: {
                    ersBlock.moveLeft();
                    break;
                }
                case 39: {
                    ersBlock.moveRight();
                    break;
                }
                case 38: {
                    ersBlock.turnNext();
                    break;
                }
            }
        }
    }

    private class TipPanel
    extends JPanel {
        private Color backColor = Color.darkGray;
        private Color frontColor = Color.lightGray;
        private ErsBox[][] boxes = new ErsBox[4][4];
        private int style;
        private int boxWidth;
        private int boxHeight;
        private boolean isTiled = false;

        public TipPanel() {
            int n = 0;
            while (n < this.boxes.length) {
                int n2 = 0;
                while (n2 < this.boxes[n].length) {
                    this.boxes[n][n2] = new ErsBox(false);
                    ++n2;
                }
                ++n;
            }
        }

        public TipPanel(Color color, Color color2) {
            this();
            this.backColor = color;
            this.frontColor = color2;
        }

        public void setStyle(int n) {
            this.style = n;
            this.repaint();
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (!this.isTiled) {
                this.fanning();
            }
            int n = 32768;
            int n2 = 0;
            while (n2 < this.boxes.length) {
                int n3 = 0;
                while (n3 < this.boxes[n2].length) {
                    Color color = (n & this.style) != 0 ? this.frontColor : this.backColor;
                    graphics.setColor(color);
                    graphics.fill3DRect(n3 * this.boxWidth, n2 * this.boxHeight, this.boxWidth, this.boxHeight, true);
                    n >>= 1;
                    ++n3;
                }
                ++n2;
            }
        }

        public void fanning() {
            this.boxWidth = this.getSize().width / 4;
            this.boxHeight = this.getSize().height / 4;
            this.isTiled = true;
        }
    }
}

