/*
 * Decompiled with CFR 0.152.
 */
class ErsBlock
extends Thread {
    public static final int BOXES_ROWS = 4;
    public static final int BOXES_COLS = 4;
    public static final int LEVEL_FLATNESS_GENE = 3;
    public static final int BETWEEN_LEVELS_DEGRESS_TIME = 50;
    private static final int BLOCK_KIND_NUMBER = 7;
    private static final int BLOCK_STATUS_NUMBER = 4;
    public static final int[][] STYLES = new int[][]{{3840, 17476, 3840, 17476}, {1248, 1124, 228, 1220}, {17952, 27648, 17952, 27648}, {9792, 50688, 9792, 50688}, {25120, 5888, 8752, 1856}, {25664, 3616, 17600, 36352}, {1632, 1632, 1632, 1632}};
    private GameCanvas canvas;
    private ErsBox[][] boxes = new ErsBox[4][4];
    private int style;
    private int y;
    private int x;
    private int level;
    private boolean pausing = false;
    private boolean moving = true;

    public ErsBlock(int n, int n2, int n3, int n4, GameCanvas gameCanvas) {
        this.style = n;
        this.y = n2;
        this.x = n3;
        this.level = n4;
        this.canvas = gameCanvas;
        int n5 = 32768;
        int n6 = 0;
        while (n6 < this.boxes.length) {
            int n7 = 0;
            while (n7 < this.boxes[n6].length) {
                boolean bl = (n & n5) != 0;
                this.boxes[n6][n7] = new ErsBox(bl);
                n5 >>= 1;
                ++n7;
            }
            ++n6;
        }
        this.display();
    }

    public void run() {
        while (this.moving) {
            try {
                Thread.sleep(50 * (10 - this.level + 3));
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            if (this.pausing) continue;
            boolean bl = this.moving = this.moveTo(this.y + 1, this.x) && this.moving;
        }
    }

    public void moveLeft() {
        this.moveTo(this.y, this.x - 1);
    }

    public void moveRight() {
        this.moveTo(this.y, this.x + 1);
    }

    public void moveDown() {
        this.moveTo(this.y + 1, this.x);
    }

    public void turnNext() {
        int n = 0;
        while (n < 7) {
            int n2 = 0;
            while (n2 < 4) {
                if (STYLES[n][n2] == this.style) {
                    int n3 = STYLES[n][(n2 + 1) % 4];
                    this.turnTo(n3);
                    return;
                }
                ++n2;
            }
            ++n;
        }
    }

    public void pauseMove() {
        this.pausing = true;
    }

    public void resumeMove() {
        this.pausing = false;
    }

    public void stopMove() {
        this.moving = false;
    }

    private void earse() {
        int n = 0;
        while (n < this.boxes.length) {
            int n2 = 0;
            while (n2 < this.boxes[n].length) {
                ErsBox ersBox;
                if (this.boxes[n][n2].isColorBox() && (ersBox = this.canvas.getBox(n + this.y, n2 + this.x)) != null) {
                    ersBox.setColor(false);
                }
                ++n2;
            }
            ++n;
        }
    }

    private void display() {
        int n = 0;
        while (n < this.boxes.length) {
            int n2 = 0;
            while (n2 < this.boxes[n].length) {
                ErsBox ersBox;
                if (this.boxes[n][n2].isColorBox() && (ersBox = this.canvas.getBox(this.y + n, this.x + n2)) != null) {
                    ersBox.setColor(true);
                }
                ++n2;
            }
            ++n;
        }
    }

    private boolean isMoveAble(int n, int n2) {
        this.earse();
        int n3 = 0;
        while (n3 < this.boxes.length) {
            int n4 = 0;
            while (n4 < this.boxes[n3].length) {
                ErsBox ersBox;
                if (this.boxes[n3][n4].isColorBox() && ((ersBox = this.canvas.getBox(n + n3, n2 + n4)) == null || ersBox.isColorBox())) {
                    this.display();
                    return false;
                }
                ++n4;
            }
            ++n3;
        }
        this.display();
        return true;
    }

    private synchronized boolean moveTo(int n, int n2) {
        if (!this.isMoveAble(n, n2) || !this.moving) {
            return false;
        }
        this.earse();
        this.y = n;
        this.x = n2;
        this.display();
        this.canvas.repaint();
        return true;
    }

    private boolean isTurnAble(int n) {
        int n2 = 32768;
        this.earse();
        int n3 = 0;
        while (n3 < this.boxes.length) {
            int n4 = 0;
            while (n4 < this.boxes[n3].length) {
                ErsBox ersBox;
                if ((n & n2) != 0 && ((ersBox = this.canvas.getBox(this.y + n3, this.x + n4)) == null || ersBox.isColorBox())) {
                    this.display();
                    return false;
                }
                n2 >>= 1;
                ++n4;
            }
            ++n3;
        }
        this.display();
        return true;
    }

    private boolean turnTo(int n) {
        if (!this.isTurnAble(n) || !this.moving) {
            return false;
        }
        this.earse();
        int n2 = 32768;
        int n3 = 0;
        while (n3 < this.boxes.length) {
            int n4 = 0;
            while (n4 < this.boxes[n3].length) {
                boolean bl = (n & n2) != 0;
                this.boxes[n3][n4].setColor(bl);
                n2 >>= 1;
                ++n4;
            }
            ++n3;
        }
        this.style = n;
        this.display();
        this.canvas.repaint();
        return true;
    }
}

