/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class ErsBlocksGame
extends JFrame {
    public static final int PER_LINE_SCORE = 100;
    public static final int PER_LEVEL_SCORE = 2000;
    public static final int MAX_LEVEL = 10;
    public static final int DEFAULT_LEVEL = 5;
    private GameCanvas canvas;
    private ErsBlock block;
    private boolean playing = false;
    private ControlPanel ctrlPanel;
    private JMenuBar bar = new JMenuBar();
    private JMenu mGame = new JMenu("Game");
    private JMenu mControl = new JMenu("Control");
    private JMenu mWindowStyle = new JMenu("WindowStyle");
    private JMenu mInfo = new JMenu("Information");
    private JMenuItem miNewGame = new JMenuItem("New Game");
    private JMenuItem miSetBlockColor = new JMenuItem("Set Block Color ...");
    private JMenuItem miSetBackColor = new JMenuItem("Set Background Color ...");
    private JMenuItem miTurnHarder = new JMenuItem("Turn up the level");
    private JMenuItem miTurnEasier = new JMenuItem("Turn down the level");
    private JMenuItem miExit = new JMenuItem("Eixt");
    private JMenuItem miPlay = new JMenuItem("Play");
    private JMenuItem miPause = new JMenuItem("Pause");
    private JMenuItem miResume = new JMenuItem("Resume");
    private JMenuItem miStop = new JMenuItem("Stop");
    private JMenuItem miAuthor = new JMenuItem("Author : apple@radiantek.com");
    private JMenuItem miSourceInfo = new JMenuItem("You can get the source code / document by email");
    private JCheckBoxMenuItem miAsWindows = new JCheckBoxMenuItem("Windows");
    private JCheckBoxMenuItem miAsMotif = new JCheckBoxMenuItem("Motif");
    private JCheckBoxMenuItem miAsMetal = new JCheckBoxMenuItem("Metal", true);

    public ErsBlocksGame(String string) {
        super(string);
        this.setSize(315, 392);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.createMenu();
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout(6, 0));
        this.canvas = new GameCanvas(20, 12);
        this.ctrlPanel = new ControlPanel(this);
        container.add((Component)this.canvas, "Center");
        container.add((Component)this.ctrlPanel, "East");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ErsBlocksGame.this.stopGame();
                System.exit(0);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                ErsBlocksGame.this.canvas.fanning();
            }
        });
        this.show();
        this.canvas.fanning();
    }

    public void reset() {
        this.ctrlPanel.reset();
        this.canvas.reset();
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public ErsBlock getCurBlock() {
        return this.block;
    }

    public GameCanvas getCanvas() {
        return this.canvas;
    }

    public void playGame() {
        this.play();
        this.ctrlPanel.setPlayButtonEnable(false);
        this.miPlay.setEnabled(false);
        this.ctrlPanel.requestFocus();
    }

    public void pauseGame() {
        if (this.block != null) {
            this.block.pauseMove();
        }
        this.ctrlPanel.setPauseButtonLabel(false);
        this.miPause.setEnabled(false);
        this.miResume.setEnabled(true);
    }

    public void resumeGame() {
        if (this.block != null) {
            this.block.resumeMove();
        }
        this.ctrlPanel.setPauseButtonLabel(true);
        this.miPause.setEnabled(true);
        this.miResume.setEnabled(false);
        this.ctrlPanel.requestFocus();
    }

    public void stopGame() {
        this.playing = false;
        if (this.block != null) {
            this.block.stopMove();
        }
        this.miPlay.setEnabled(true);
        this.miPause.setEnabled(true);
        this.miResume.setEnabled(false);
        this.ctrlPanel.setPlayButtonEnable(true);
        this.ctrlPanel.setPauseButtonLabel(true);
    }

    public int getLevel() {
        return this.ctrlPanel.getLevel();
    }

    public void setLevel(int n) {
        if (n < 11 && n > 0) {
            this.ctrlPanel.setLevel(n);
        }
    }

    public int getScore() {
        if (this.canvas != null) {
            return this.canvas.getScore();
        }
        return 0;
    }

    public int getScoreForLevelUpdate() {
        if (this.canvas != null) {
            return this.canvas.getScoreForLevelUpdate();
        }
        return 0;
    }

    public boolean levelUpdate() {
        int n = this.getLevel();
        if (n < 10) {
            this.setLevel(n + 1);
            this.canvas.resetScoreForLevelUpdate();
            return true;
        }
        return false;
    }

    private void play() {
        this.reset();
        this.playing = true;
        Thread thread = new Thread(new Game());
        thread.start();
    }

    private void reportGameOver() {
        JOptionPane.showMessageDialog(this, "Game Over!");
    }

    private void createMenu() {
        this.bar.add(this.mGame);
        this.bar.add(this.mControl);
        this.bar.add(this.mWindowStyle);
        this.bar.add(this.mInfo);
        this.mGame.add(this.miNewGame);
        this.mGame.addSeparator();
        this.mGame.add(this.miSetBlockColor);
        this.mGame.add(this.miSetBackColor);
        this.mGame.addSeparator();
        this.mGame.add(this.miTurnHarder);
        this.mGame.add(this.miTurnEasier);
        this.mGame.addSeparator();
        this.mGame.add(this.miExit);
        this.mControl.add(this.miPlay);
        this.mControl.add(this.miPause);
        this.mControl.add(this.miResume);
        this.mControl.add(this.miStop);
        this.mWindowStyle.add(this.miAsWindows);
        this.mWindowStyle.add(this.miAsMotif);
        this.mWindowStyle.add(this.miAsMetal);
        this.mInfo.add(this.miAuthor);
        this.mInfo.add(this.miSourceInfo);
        this.setJMenuBar(this.bar);
        this.miPause.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        this.miResume.setAccelerator(KeyStroke.getKeyStroke(10, 0));
        this.miNewGame.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ErsBlocksGame.this.stopGame();
                ErsBlocksGame.this.reset();
                ErsBlocksGame.this.setLevel(5);
            }
        });
        this.miSetBlockColor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Color color = JColorChooser.showDialog(ErsBlocksGame.this, "Set color for block", ErsBlocksGame.this.canvas.getBlockColor());
                if (color != null) {
                    ErsBlocksGame.this.canvas.setBlockColor(color);
                }
            }
        });
        this.miSetBackColor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Color color = JColorChooser.showDialog(ErsBlocksGame.this, "Set color for block", ErsBlocksGame.this.canvas.getBackgroundColor());
                if (color != null) {
                    ErsBlocksGame.this.canvas.setBackgroundColor(color);
                }
            }
        });
        this.miTurnHarder.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = ErsBlocksGame.this.getLevel();
                if (n < 10) {
                    ErsBlocksGame.this.setLevel(n + 1);
                }
            }
        });
        this.miTurnEasier.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = ErsBlocksGame.this.getLevel();
                if (n > 1) {
                    ErsBlocksGame.this.setLevel(n - 1);
                }
            }
        });
        this.miExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        this.miPlay.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ErsBlocksGame.this.playGame();
            }
        });
        this.miPause.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ErsBlocksGame.this.pauseGame();
            }
        });
        this.miResume.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ErsBlocksGame.this.resumeGame();
            }
        });
        this.miStop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ErsBlocksGame.this.stopGame();
            }
        });
        this.miAsWindows.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
                ErsBlocksGame.this.setWindowStyle(string);
                ErsBlocksGame.this.canvas.fanning();
                ErsBlocksGame.this.ctrlPanel.fanning();
                ErsBlocksGame.this.miAsWindows.setState(true);
                ErsBlocksGame.this.miAsMetal.setState(false);
                ErsBlocksGame.this.miAsMotif.setState(false);
            }
        });
        this.miAsMotif.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
                ErsBlocksGame.this.setWindowStyle(string);
                ErsBlocksGame.this.canvas.fanning();
                ErsBlocksGame.this.ctrlPanel.fanning();
                ErsBlocksGame.this.miAsWindows.setState(false);
                ErsBlocksGame.this.miAsMetal.setState(false);
                ErsBlocksGame.this.miAsMotif.setState(true);
            }
        });
        this.miAsMetal.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = "javax.swing.plaf.metal.MetalLookAndFeel";
                ErsBlocksGame.this.setWindowStyle(string);
                ErsBlocksGame.this.canvas.fanning();
                ErsBlocksGame.this.ctrlPanel.fanning();
                ErsBlocksGame.this.miAsWindows.setState(false);
                ErsBlocksGame.this.miAsMetal.setState(true);
                ErsBlocksGame.this.miAsMotif.setState(false);
            }
        });
    }

    private void setWindowStyle(String string) {
        try {
            UIManager.setLookAndFeel(string);
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void main(String[] stringArray) {
        new ErsBlocksGame("Russia Blocks by apple@radiantek.com");
    }

    private class Game
    implements Runnable {
        private Game() {
        }

        public void run() {
            int n = (int)(Math.random() * (double)(ErsBlocksGame.this.canvas.getCols() - 3));
            int n2 = ErsBlock.STYLES[(int)(Math.random() * 7.0)][(int)(Math.random() * 4.0)];
            while (ErsBlocksGame.this.playing) {
                if (ErsBlocksGame.this.block != null && ErsBlocksGame.this.block.isAlive()) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                    continue;
                }
                this.checkFullLine();
                if (this.isGameOver()) {
                    ErsBlocksGame.this.miPlay.setEnabled(true);
                    ErsBlocksGame.this.miPause.setEnabled(true);
                    ErsBlocksGame.this.miResume.setEnabled(false);
                    ErsBlocksGame.this.ctrlPanel.setPlayButtonEnable(true);
                    ErsBlocksGame.this.ctrlPanel.setPauseButtonLabel(true);
                    ErsBlocksGame.this.reportGameOver();
                    return;
                }
                ErsBlocksGame.this.block = new ErsBlock(n2, -1, n, ErsBlocksGame.this.getLevel(), ErsBlocksGame.this.canvas);
                ErsBlocksGame.this.block.start();
                n = (int)(Math.random() * (double)(ErsBlocksGame.this.canvas.getCols() - 3));
                n2 = ErsBlock.STYLES[(int)(Math.random() * 7.0)][(int)(Math.random() * 4.0)];
                ErsBlocksGame.this.ctrlPanel.setTipStyle(n2);
            }
        }

        public void checkFullLine() {
            int n = 0;
            while (n < ErsBlocksGame.this.canvas.getRows()) {
                int n2 = -1;
                boolean bl = true;
                int n3 = 0;
                while (n3 < ErsBlocksGame.this.canvas.getCols()) {
                    if (!ErsBlocksGame.this.canvas.getBox(n, n3).isColorBox()) {
                        bl = false;
                        break;
                    }
                    ++n3;
                }
                if (bl) {
                    n2 = n--;
                    ErsBlocksGame.this.canvas.removeLine(n2);
                }
                ++n;
            }
        }

        private boolean isGameOver() {
            int n = 0;
            while (n < ErsBlocksGame.this.canvas.getCols()) {
                ErsBox ersBox = ErsBlocksGame.this.canvas.getBox(0, n);
                if (ersBox.isColorBox()) {
                    return true;
                }
                ++n;
            }
            return false;
        }
    }
}

