/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;

class GameCanvas
extends JPanel {
    private Color backColor = Color.black;
    private Color frontColor = Color.orange;
    private int rows;
    private int cols;
    private int score = 0;
    private int scoreForLevelUpdate = 0;
    private ErsBox[][] boxes;
    private int boxWidth;
    private int boxHeight;

    public GameCanvas(int n, int n2) {
        this.rows = n;
        this.cols = n2;
        this.boxes = new ErsBox[n][n2];
        int n3 = 0;
        while (n3 < this.boxes.length) {
            int n4 = 0;
            while (n4 < this.boxes[n3].length) {
                this.boxes[n3][n4] = new ErsBox(false);
                ++n4;
            }
            ++n3;
        }
        this.setBorder(new EtchedBorder(0, Color.white, new Color(148, 145, 140)));
    }

    public GameCanvas(int n, int n2, Color color, Color color2) {
        this(n, n2);
        this.backColor = color;
        this.frontColor = color2;
    }

    public void setBackgroundColor(Color color) {
        this.backColor = color;
    }

    public Color getBackgroundColor() {
        return this.backColor;
    }

    public void setBlockColor(Color color) {
        this.frontColor = color;
    }

    public Color getBlockColor() {
        return this.frontColor;
    }

    public int getRows() {
        return this.rows;
    }

    public int getCols() {
        return this.cols;
    }

    public int getScore() {
        return this.score;
    }

    public int getScoreForLevelUpdate() {
        return this.scoreForLevelUpdate;
    }

    public void resetScoreForLevelUpdate() {
        this.scoreForLevelUpdate -= 2000;
    }

    public ErsBox getBox(int n, int n2) {
        if (n < 0 || n > this.boxes.length - 1 || n2 < 0 || n2 > this.boxes[0].length - 1) {
            return null;
        }
        return this.boxes[n][n2];
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        graphics.setColor(this.frontColor);
        int n = 0;
        while (n < this.boxes.length) {
            int n2 = 0;
            while (n2 < this.boxes[n].length) {
                graphics.setColor(this.boxes[n][n2].isColorBox() ? this.frontColor : this.backColor);
                graphics.fill3DRect(n2 * this.boxWidth, n * this.boxHeight, this.boxWidth, this.boxHeight, true);
                ++n2;
            }
            ++n;
        }
    }

    public void fanning() {
        this.boxWidth = this.getSize().width / this.cols;
        this.boxHeight = this.getSize().height / this.rows;
    }

    public synchronized void removeLine(int n) {
        int n2 = n;
        while (n2 > 0) {
            int n3 = 0;
            while (n3 < this.cols) {
                this.boxes[n2][n3] = (ErsBox)this.boxes[n2 - 1][n3].clone();
                ++n3;
            }
            --n2;
        }
        this.score += 100;
        this.scoreForLevelUpdate += 100;
        this.repaint();
    }

    public void reset() {
        this.score = 0;
        this.scoreForLevelUpdate = 0;
        int n = 0;
        while (n < this.boxes.length) {
            int n2 = 0;
            while (n2 < this.boxes[n].length) {
                this.boxes[n][n2].setColor(false);
                ++n2;
            }
            ++n;
        }
        this.repaint();
    }
}

